<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Choose_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'choose_slider';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Choose Slider', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'choose_slider',
			[
				'label' => esc_html__( 'Choose Slider', 'dogri-elementor' ),
			]
		);	
		
		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'theme-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'theme-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'theme-elementor' ),
				),
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your sub title', 'dogri-elementor' ),
			]
		);
		
	
		$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
				]
			);
	

		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								
								'block_image' =>
								[
									'name' => 'block_image',
									'label' => __( 'Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								  ],	

								  'block_alt_text' =>
								  [
								  'name' => 'block_alt_text',
								  'label' => esc_html__('Image Alt Text', 'dogri-elementor'),
								  'type' => Controls_Manager::TEXTAREA,
								  'default' => esc_html__('', 'dogri-elementor')
								  ],

								  'block_subtitle' =>
								  [
									  'name' => 'block_subtitle',
									  'label' => esc_html__('Sub Title', 'dogri-elementor'),
									  'type' => Controls_Manager::TEXTAREA,
									  'default' => esc_html__('', 'dogri-elementor')
								  ],

								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_text' =>
								[
									'name' => 'block_text',
									'label' => esc_html__('Text', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
																
								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	


		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-3' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'display: {{VALUE}} !important',
				), 
			)
		);

		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-subtitle-3' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'text-align: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-subtitle-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-subtitle-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-6' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),

			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-subtitle-3',
				'selector' => '{{WRAPPER}} .section-subtitle-6',
			)
		);


		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-3' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-title-3' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-title-3',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	


		// Title 	==================	


		$this->start_controls_section(
			'title_settings',
			array(
				'label' => __( 'Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
				
		$this->add_control(
			'show_title',
			array(
				'label' => esc_html__( 'Show Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 h4' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .advantage-content h4' => 'display: {{VALUE}} !important',
				),   
			)
		);
		
		$this->add_control(
			'title_alignment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .why-choose-content-2 h4' => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .advantage-content h4' => 'text-align: {{VALUE}}',
				),
			)
		);
		
		$this->add_control(
			'title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .advantage-content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .advantage-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'condition'    => array( 'show_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .why-choose-content-2 h4',
				'selector' => '{{WRAPPER}} .advantage-content h4',
			)
		);
		
		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 h4' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .advantage-content h4' => 'color: {{VALUE}} !important',
		
				),
			)
		);

		$this->add_control(
			'title_hover_color',
			array(
				'label'     => __( 'Hover Color', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 h4:hover' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .advantage-content h4:hover' => 'color: {{VALUE}} !important',
		
				),
			)
		);

		$this->end_controls_section();	
		
		
		//End of  Title 	==================


		//Text==========================
		$this->start_controls_section(
			'text_settings',
			array(
				'label' => __( 'Text Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		
		$this->add_control(
			'show_text',
			array(
				'label' => esc_html__( 'Show Text', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 p' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .advantage-content P' => 'display: {{VALUE}} !important',
				),   
			)
		);
		
		$this->add_control(
			'text_alignment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_text' => 'show' ),
				'toggle' => true,
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 p' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .advantage-content P' => 'text-align: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'text_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .advantage-content P' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_control(
			'text_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .advantage-content P' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'text_typography',
				'condition'    => array( 'show_text' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .why-choose-content-2 p',
				'selector' => '{{WRAPPER}} .advantage-content P',
			)
		); 
		
		$this->add_control(
			'text_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 p' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .advantage-content P' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'text_hover_color',
			array(
				'label'     => __( 'Hover Color', 'dogri-elementor' ),
				'condition'    => array( 'show_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .why-choose-content-2 p:hover' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .advantage-content P:hover' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();
		//End of Text=========	


				//========== icon Settings===================================
				
				$this->start_controls_section(
					'icon_control',
					array(
						'label' => __( 'Icon Settings', 'dogri-elementor' ),
						'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
					)
				);
				
				$this->add_control(
					'show_icon',
					array(
						'label' => esc_html__( 'Show Icon', 'dogri-elementor' ),
						'type' => \Elementor\Controls_Manager::CHOOSE,
						'options' => [
							'show' => [
								'show' => esc_html__( 'Show', 'dogri-elementor' ),	
								'icon' => 'eicon-check-circle',
							],
							'none' => [
								'none' => esc_html__( 'Hide', 'dogri-elementor' ),
								'icon' => 'eicon-close-circle',
							],
						],
						'default' => 'show',
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span' => 'display: {{VALUE}} !important',
							'{{WRAPPER}} .advantage-icon > span' => 'display: {{VALUE}} !important',
						),
					)
				);
				
				$this->add_control(
					'icon_alingment',
					array(
						'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
						'type' => \Elementor\Controls_Manager::CHOOSE,
						'condition'    => array( 'show_icon' => 'show' ),
						'options' => [
							'left' => [
								'title' => esc_html__( 'Left', 'dogri-elementor' ),
								'icon' => 'eicon-text-align-left',
							],
							'center' => [
								'title' => esc_html__( 'Center', 'dogri-elementor' ),
								'icon' => 'eicon-text-align-center',
							],
							'right' => [
								'title' => esc_html__( 'Right', 'dogri-elementor' ),
								'icon' => 'eicon-text-align-right',
							],
						],
						'default' => '',
						'toggle' => true,
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span' => 'text-align: {{VALUE}} !important',
							'{{WRAPPER}} .advantage-icon > span' => 'text-align: {{VALUE}} !important',
						),
					)
				);	
				
				$this->add_control(
					'icon_color',
					array(
						'label'     => __( ' Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span' => 'color: {{VALUE}} !important',
							'{{WRAPPER}} .advantage-icon > span' => 'color: {{VALUE}} !important',

						),
					)
				);
				
				$this->add_control(
					'icon_bgcolor',
					array(
						'label'     => __( 'Background Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span' => 'background: {{VALUE}} !important',
							'{{WRAPPER}} .advantage-icon > span' => 'background: {{VALUE}} !important',

						),
					)
				);
				
				
				$this->add_control(
					'icon_hover_color',
					array(
						'label'     => __( ' Hover Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span:hover' => 'color: {{VALUE}} !important',
							'{{WRAPPER}} .advantage-icon > span:hover' => 'color: {{VALUE}} !important',

						),
					)
				);
				
				$this->add_control(
					'icon_hover_bgcolor',
					array(
						'label'     => __( 'Background Hover Color', 'dogri-elementor' ),
						'condition'    => array( 'show_icon' => 'show' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span:hover' => 'background: {{VALUE}} !important',
							'{{WRAPPER}} .advantage-icon > span:hover' => 'background: {{VALUE}} !important',

						),
					)
				);
				
				$this->add_control(
					'icon_padding',
					array(
						'label'     => __( 'Padding', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'condition'    => array( 'show_icon' => 'show' ),
						'size_units' =>  ['px', '%', 'em' ],
					
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
							'{{WRAPPER}} .advantage-icon > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
						),
					)
				);

				$this->add_control(
					'icon_margin',
					array(
						'label'     => __( 'Margin', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'condition'    => array( 'show_icon' => 'show' ),
						'size_units' =>  ['px', '%', 'em' ],
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
							'{{WRAPPER}} .advantage-icon > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
						),
					)
				);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					array(
						'name'     => 'icon_typography',
						'condition'    => array( 'show_icon' => 'show' ),
						'label'    => __( 'Typography', 'dogri-elementor' ),
						'selector' => '{{WRAPPER}} .why-choose-icon-2 span',
						'selector' => '{{WRAPPER}} .advantage-icon > span',
					)
				);
				
				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					array(
						'name' => 'icon_border',
						'condition'    => array( 'show_icon' => 'show' ),
						'selector' => '{{WRAPPER}} .why-choose-icon-2 span',
						'selector' => '{{WRAPPER}} .advantage-icon > span',
					)
				);
				
				$this->add_control(
					'icon_border_radius',
					array(
						'label'     => __( 'Icon Border Radius', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'condition'    => array( 'show_icon' => 'show' ),
						'size_units' =>  ['px', '%', 'em' ],
					
						'selectors' => array(
							'{{WRAPPER}} .why-choose-icon-2 span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
							'{{WRAPPER}} .advantage-icon > span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
						),
					)
				);


				$this->end_controls_section();		
				
				//End of icon

				//Background Color ==========================

				$this->start_controls_section(
					'bg_color_block_settings',
					array(
						'label' => __( 'Background Color Setting', 'dogri-elementor' ),
						'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
					)
				);			

				$this->add_control(
					'block_bg_color',
					array(
						'label'     => __( 'Section Background Color', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::COLOR,
						'selectors' => array(
							'{{WRAPPER}} .why-choose-area' => 'background-color: {{VALUE}} !important',
						),
					)
				);


				$this->end_controls_section();

				//End of Background Color  

				//Section Padding Block==========================
				$this->start_controls_section(
					'section_padding_settings',
					array(
						'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
						'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
					)
				);
				
				$this->add_control(
					'block_margin',
					array(
						'label'     => __( 'Block Margin', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' =>  ['px', '%', 'em' ],
					
						'selectors' => array(
							'{{WRAPPER}} .why-choose-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
							'{{WRAPPER}} .advantage-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
						),
						'responsive' => true, // This enables responsive settings
					)
				);
		
				$this->add_control(
					'block_padding',
					array(
						'label'     => __( 'Block Padding', 'dogri-elementor' ),
						'type'      => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' =>  ['px', '%', 'em' ],
					
						'selectors' => array(
							'{{WRAPPER}} .why-choose-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
							'{{WRAPPER}} .advantage-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
						),
						'responsive' => true, // This enables responsive settings
					)
				);
		
				$this->end_controls_section();
				//End of Section Padding Block 


	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 

var whyChoose = new Swiper(".why-choose-active", {
	slidesPerView: 1,
	spaceBetween: 0,
	loop: true,
	autoplay: {
	  delay: 3000,
	},
	pagination: {
		el: ".bd-swiper-dot",
		clickable: true,
	},
	breakpoints: {  
		"1200": {
			slidesPerView: 3,
		},
		"992": {
			slidesPerView: 3,
		},
		"768": {
			slidesPerView: 1,
		},
		"576": {
			slidesPerView: 1,
		},
		"0": {
			slidesPerView: 1,
		},
	},
});

//write code above the line 

  });
</script>';


?>

<?php  if ( 'style1' === $settings['style'] ) : ?>

         <!-- why-choose area start -->
		 <section class="why-choose-area theme-bg-4 section-space">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-4 col-xl-5">
                  <div class="section-title-wrapper-3 section-title-space text-center">
                     <span class="section-subtitle-3 mb-15"><?php echo $settings['subtitle'];?></span>
                     <h2 class="section-title-3"><?php echo $settings['title'];?></h2>
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col-xxl-12">
                  <div class="swiper why-choose-active">
                     <div class="swiper-wrapper">
					 	<?php foreach($settings['repeat'] as $item):?>
                        <div class="swiper-slide">
                           <div class="why-choose-item-2 text-center">
                              <div class="why-choose-content-2">
                                 <div class="why-choose-icon-2">
                                    <span><img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>"><span><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span></span>
                                 </div>
                                 <h4><?php echo wp_kses($item['block_title'], $allowed_tags);?></h4>
                                 <p><?php echo wp_kses($item['block_text'], $allowed_tags);?></p>
                              </div>
                           </div>
                        </div>
						<?php endforeach; ?>
                     </div>
                     <div class=" why-choose-pagination text-center">
                        <div class="bd-swiper-dot"></div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- why-choose area end -->
	  <?php  elseif ( 'style2' === $settings['style'] ) : ?>

   <!-- Advantage area start -->
   <section class="advantage-area section-space">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-5 col-xl-5 col-lg-5">
                  <div class="section-title-wrapper-5 text-center section-title-space">
                     <span class="section-subtitle-6 mb-25"><?php echo $settings['subtitle'];?></span>
                     <h2 class="section-title-3"><?php echo $settings['title'];?></h2>
                  </div>
               </div>
            </div>
            <div class="row g-5">
			<?php foreach($settings['repeat'] as $item):?>
               <div class="col-xxl-4 col-xl-4 col-lg-4">
                  <div class="advantage-item text-center wow fadeIn" data-wow-delay=".3s">
                     <div class="advantage-content">
                        <div class="advantage-icon">
						<span><img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>"><span class="advantage-count"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span></span>
                        </div>
                        <h4><?php echo wp_kses($item['block_title'], $allowed_tags);?></h4>
                        <p><?php echo wp_kses($item['block_text'], $allowed_tags);?></p>
                     </div>
                  </div>
               </div>
			   <?php endforeach; ?>
            </div>
         </div>
      </section>
      <!-- Advantage area end -->

	<?php endif; ?>	



             
		<?php 
	}


}