<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Appointment_Form extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'appointment_form';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Appointment Form', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'appointment_form',
			[
				'label' => esc_html__( 'Appointment Form', 'dogri-elementor' ),
			]
		);	

		$this->add_control(
			'image',
				[
				  'label' => __( 'Image', 'dogri-elementor' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
		);	
		
		$this->add_control(
			'alt_text',
			[
				'label'       => __( 'Alt text', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description', 'dogri-elementor' ),
			]
		);


		$this->add_control(
			'contact_form',
			[
				'label'       => __( 'Contact Form 7 Url', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Form 7 Short-code', 'dogri-elementor' ),
				'default'     => __( '', 'dogri-elementor' ),
			]
		);

			
		
		
		$this->end_controls_section();


		
	//========== Button with Background ===================================

	$this->start_controls_section(
		'button_control',
		array(
			'label' => __( 'Button Settings', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'show_button',
		array(
			'label' => esc_html__( 'Show Button', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .appointment-form-area .fill-btn' => 'display: {{VALUE}} !important',
			),
		)
	);		
	$this->add_control(
		'button_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'condition'    => array( 'show_button' => 'show' ),
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'left',
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}} .appointment-form-area .fill-btn' => 'text-align: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_color',
		array(
			'label'     => __( 'Button Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .appointment-form-area .fill-btn' => 'color: {{VALUE}} !important',

			),
		)
	);
	$this->add_control(
		'button_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .appointment-form-area .fill-btn' => 'background: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .appointment-form-area .fill-btn:before' => 'background: {{VALUE}} !important',
			),
		)
	);				
	$this->add_control(
		'button_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .appointment-form-area .fill-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'button_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
			'selectors' => array(
				'{{WRAPPER}} .appointment-form-area .fill-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'button_typography',
			'condition'    => array( 'show_button' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .appointment-form-area .fill-btn',
		)
	);
	$this->add_group_control(
		\Elementor\Group_Control_Border::get_type(),
		array(
			'name' => 'border',
			'condition'    => array( 'show_button' => 'show' ),
			'selector' => '{{WRAPPER}} .appointment-form-area .fill-btn',
		)
	);
	$this->add_control(
		'border_radius',
		array(
			'label' => esc_html__( 'Border Radius', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' => [ 'px', '%' ],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 1000,
					'step' => 5,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 50,
			],
			'selectors' => [
				'{{WRAPPER}} .appointment-form-area .fill-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		)
	);

	$this->end_controls_section();

	//End of Button	

    //Background Color ==========================

    $this->start_controls_section(
        'bg_color_block_settings',
        array(
            'label' => __( 'Background Color Setting', 'dogri-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        )
    );			

    $this->add_control(
        'block_bg_color',
        array(
            'label'     => __( 'Section Background Color', 'dogri-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .appointment-form-area' => 'background-color: {{VALUE}} !important',
            ),
        )
    );

  

    $this->end_controls_section();

    //End of Background Color  

	//Section Padding Block==========================
	$this->start_controls_section(
		'section_padding_settings',
		array(
			'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'block_margin',
		array(
			'label'     => __( 'Block Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .appointment-input-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->add_control(
		'block_padding',
		array(
			'label'     => __( 'Block Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .appointment-input-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->end_controls_section();
	//End of Section Padding Block 
	
		
	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 


//write code above the line 

  });
</script>';


?>


      <!-- Appointment area start -->
	  <div class="appointment-form-area theme-bg-1 p-relative">
      <div class="container">
         <div class="row">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
               <div class="appointment-thumb-2 w-img">
			   	<?php  if ( !empty(esc_url($settings['image']['id']) )) : ?>   
					<img src="<?php echo wp_get_attachment_url($settings['image']['id']);?>" alt="<?php echo esc_attr($settings['alt_text']);?>"/>
				<?php endif;?>
               </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6">
               <div class="appointment-input-wrapper section-space">
					<?php echo do_shortcode( $settings['contact_form'] );?>	
               </div>
            </div>
         </div>
      </div>
   </div>
   <!-- Appointment area end -->



             
		<?php 
	}


}