<?php

  // Namespace
  namespace BMI\Plugin\Uninstaller;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

  // Get config
  $dir = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration' . DIRECTORY_SEPARATOR;
  $config = $dir . 'config.json';
  if (file_exists($config)) {
    $config = json_decode(file_get_contents($config));
    if (json_last_error() == JSON_ERROR_NONE) {

      if (isset($config->{'OTHER:UNINSTALL:BACKUPS'})) {
        if ($config->{'OTHER:UNINSTALL:BACKUPS'} === 'true' || $config->{'OTHER:UNINSTALL:BACKUPS'} === true) {
          if (isset($config->{'STORAGE::LOCAL::PATH'})) {
            if ($config->{'STORAGE::LOCAL::PATH'} == 'default') {
              $backups = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'backup-migration' . DIRECTORY_SEPARATOR . 'backups';
            } else {
              $backups = $config->{'STORAGE::LOCAL::PATH'} . DIRECTORY_SEPARATOR . 'backups';
            }

            if (file_exists($backups) && is_dir($backups)) {

              $files = scandir($backups);
              for ($i = 0; $i < sizeof($files); ++$i) {

                $file = $backups . DIRECTORY_SEPARATOR . $files[$i];
                if (is_file($file) && !in_array($files[$i], ['.', '..'])) {
                  @unlink($file);
                }

              }

              $files = scandir($backups);
              if (sizeof($files) <= 2) rmdir($backups);

            }
          }
        }
      }

      if (isset($config->{'OTHER:UNINSTALL:CONFIGS'})) {
        if ($config->{'OTHER:UNINSTALL:CONFIGS'} === 'true' || $config->{'OTHER:UNINSTALL:CONFIGS'} === true) {

          $files = scandir($dir);
          for ($i = 0; $i < sizeof($files); ++$i) {

            $file = $dir . DIRECTORY_SEPARATOR . $files[$i];
            if (is_file($file) && !in_array($files[$i], ['.', '..'])) {
              @unlink($file);
            }

          }

          $files = scandir($dir);
          if (sizeof($files) <= 2) rmdir($dir);

        }
      }

    }

    if (function_exists('delete_option')) {
      delete_option('bmi_pro_gd_client_id');
      delete_option('bmi_pro_gd_token');
    }
  }
