<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Portfolio_Post_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Dogri Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'portfolio_post_widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Dogri Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Portfolio', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Dogri Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Dogri Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}

	public function get_keywords() {
		return [ 'portfolio' ];
	}

	public function get_script_depends() {
		return [ 'dogri-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Section Heading', 'dogri-elementor' ),
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'It is sub heading', 'dogri-elementor' ),
				'placeholder' => __( 'Enter your subheading here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'It is heading', 'dogri-elementor' ),
				'placeholder' => __( 'Enter your heading here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'text',
			[
				'label'       => __( 'Description Text', 'theme-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description', 'theme-elementor' ),
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_portfolio_post',
			[
				'label' => esc_html__( 'Portfolio Post', 'dogri-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'portfolio_style_1'  => esc_html__( 'Portfolios Style 1', 'dogri-elementor' ),
					'portfolio_style_2' => esc_html__( 'Portfolios Style 2', 'dogri-elementor' )
				],
				'default'   => 'portfolio_style_1',
			]
		);


		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'dogri-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'content_word_count',
			[
				'label'       => __( 'Content Word Count', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'dogri-elementor' ),
				'default'   => 15,				
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'dogri-elementor' ),
					'2'  => esc_html__( '2', 'dogri-elementor' ),
					'3'  => esc_html__( '3', 'dogri-elementor' ),
					'4'  => esc_html__( '4', 'dogri-elementor' ),
					'5'  => esc_html__( '5', 'dogri-elementor' ),
					'6' => esc_html__( '6', 'dogri-elementor' ),
					'7' => esc_html__( '7', 'dogri-elementor' ),
					'8' => esc_html__( '8', 'dogri-elementor' ),
					'9' => esc_html__( '9', 'dogri-elementor' ),
					'10' => esc_html__( '10', 'dogri-elementor' ),
					'-1' => esc_html__( 'Show All', 'dogri-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'dogri-elementor' ),
					'title'  => esc_html__( 'Title', 'dogri-elementor' ),
					'date' => esc_html__( 'Date', 'dogri-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'dogri-elementor' ),
					'rand' => esc_html__( 'Random Order', 'dogri-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'dogri-elementor' ),
				],
				'default'   => 'ID',
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'dogri-elementor' ),
					'desc' => esc_html__( 'DESC', 'dogri-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Category Slug', 'dogri-elementor' ),
				'label_block' => true,				
			]
		);

		$this->add_control(
			'service_link_text',
			[
				'label'       => esc_html__( 'Service Button Text', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Read More ', 'dogri-elementor' ),
				'placeholder' => esc_html__( 'Link Text', 'dogri-elementor' ),
				'label_block' => true
			]
		);		

		$this->add_control(
			'service_icon_name',
			[
				'label'       => esc_html__( 'Service btn Icon Name', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'fa-solid fa-angle-right', 'dogri-elementor' ),
				'placeholder' => esc_html__( 'icon name here', 'dogri-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'service_btn_on',
			[
				'label'   => esc_html__( 'Service BTN Switch', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'service_icon_on',
			[
				'label'   => esc_html__( 'Service icon Switch', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'service_btn_on' => 'yes'
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'dogri-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	


		$this->end_controls_section();


		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-6' => 'display: {{VALUE}} !important',
				), 
			)
		);

		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-subtitle-6' => 'text-align: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-subtitle-6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-subtitle-6' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),

			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-subtitle-6',
			)
		);


		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-6' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-6' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


		// Section Title 	==================
				
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		

		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'display: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-title-3' => 'text-align: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-title-3',
			)
		);

		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-title-3' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	


		//Section Title Text==========================
		$this->start_controls_section(
			'section_title_text_settings',
			array(
				'label' => __( 'Section Title Text Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'show_section_title_text',
			array(
				'label' => esc_html__( 'Show Section Title Text', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .project-content-wrap p' => 'display: {{VALUE}} !important',
				), 
			)
		);

		$this->add_control(
			'section_title_text_alingment',
			array(
				'label' => esc_html__( 'Section Title Text Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'toggle' => true,
				'selectors' => array(
					'{{WRAPPER}} .project-content-wrap p' => 'text-align: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_title_text_margin',
			array(
				'label'     => __( 'Section Text Margin', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .project-content-wrap p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		); 

		$this->add_control(
			'section_title_text_padding',
			array(
				'label'     => __( 'Section Text Padding', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .project-content-wrap p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_text_typography',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .project-content-wrap p',
			)
		);

		$this->add_control(
			'section_title_text_color',
			array(
				'label'     => __( 'Section Text Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .project-content-wrap p' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();
		//End of Section Title Text=========	

		    //Background Color ==========================

			$this->start_controls_section(
				'bg_color_block_settings',
				array(
					'label' => __( 'Background Color Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);			
		
			$this->add_control(
				'block_bg_color',
				array(
					'label'     => __( 'Section Background Color', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .project-area' => 'background-color: {{VALUE}} !important',
					),
				)
			);
		
		
			$this->end_controls_section();
		
			//End of Background Color  

			//Section Padding Block==========================
			$this->start_controls_section(
				'section_padding_settings',
				array(
					'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);
			
			$this->add_control(
				'block_margin',
				array(
					'label'     => __( 'Block Margin', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .project-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					),
					'responsive' => true, // This enables responsive settings
				)
			);
	
			$this->add_control(
				'block_padding',
				array(
					'label'     => __( 'Block Padding', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .project-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					),
					'responsive' => true, // This enables responsive settings
				)
			);
	
			$this->end_controls_section();
			//End of Section Padding Block 


	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		extract( $settings );
		?>

	<?php 
	if( $chose_style == 'portfolio_style_1' ): ?>
      <!-- Project area start -->
      <section class="project-area theme-bg-4 section-space p-relative fix">
         <div class="container">
            <div class="row gy-50">
               <div class="col-xxl-4 col-xl-4 col-lg-4">
					<?php 
                    if( $settings['show_heading_section'] == 'yes'): ?>
                  <div class="project-content-wrap">
                     <div class="section-title-wrapper-5 mb-30">
					 	<?php 
                        if (( '' !== $sub_heading ) && ( $show_sub_heading )) : ?>
                        <span class="section-subtitle-6 mb-25"><?php print wp_kses_post( $sub_heading ); ?></span>
						<?php 
                        endif; ?>
						<?php 
                        if (( '' !== $heading ) && ( $show_heading )) : ?>
                        <h2 class="section-title-3"><?php print wp_kses_post( $heading ); ?></h2>
						<?php 
                        endif; ?>
                     </div>
                     <p><?php echo $settings['text'];?></p>
                  </div>
				  <?php
                	endif; ?>
               </div>
               <div class="col-xxl-7 col-xl-7 col-lg-7">
                  <div class="swiper project-active">
                     <div class="swiper-wrapper">
					 <?php 
                        if( !empty($cat->term_id) ){
                            $q = new \WP_Query(array(
                                'post_type'     => 'dogri-portfolio',
                                'posts_per_page'=> $post_number,
                                'orderby' 		=> 'menu_order '.$orderby,
                                'order'			=> $post_order,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'portfolio_categories',
                                        'field'    => 'term_id',
                                        'terms'    => array( $term_id ),
                                        'operator' => 'IN',
                                    ),
                                ),
                            ));
                        
                        }else{
                            $q = new \WP_Query(array(
                                'post_type'     => 'dogri-portfolio',
                                'posts_per_page'=> $post_number,
                                'orderby' 		=> 'menu_order '.$orderby,
                                'order'			=> $post_order,
                            ));
                        }
                            
                        if($q->have_posts()):
                            while($q->have_posts()): $q->the_post(); 
                            $sub_title = get_post_meta(get_the_ID(), 'portfolio_service_sub_title', true);
                            ?>
                        <div class="swiper-slide">
                           <div class="project-item">
                              <div class="project-thumb w-img">
                                 <img src="<?php echo the_post_thumbnail_url('dogri-portfolio-thumb'); ?>" alt="">
                              </div>
                              <div class="project-content-inner">
                                 <div class="project-content">
                                    <span><?php echo wp_trim_words( $sub_title, $content_word_count, '' ); ?></span>
                                    <h4><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h4>
                                 </div>
                                 <a class="round-link-40" href="<?php the_permalink(); ?>"><i
                                       class="fa-regular fa-angle-right"></i></a>
                              </div>
                           </div>
                        </div>
						<?php 
                            endwhile; 
                            wp_reset_postdata(); 
                        endif; 
                        ?>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Project area end -->

	<?php 
	elseif( $chose_style == 'portfolio_style_2' ): ?>
		
	<!-- Project area start -->
	<section class="project-area theme-bg-4 section-space p-relative fix">
		<div class="container">
			<div class="row g-5">
			<?php 
			if( !empty($cat->term_id) ){
				$q = new \WP_Query(array(
					'post_type'     => 'dogri-portfolio',
					'posts_per_page'=> $post_number,
					'orderby' 		=> 'menu_order '.$orderby,
					'order'			=> $post_order,
					'tax_query' => array(
						array(
							'taxonomy' => 'portfolio_categories',
							'field'    => 'term_id',
							'terms'    => array( $term_id ),
							'operator' => 'IN',
						),
					),
				));
			
			}else{
				$q = new \WP_Query(array(
					'post_type'     => 'dogri-portfolio',
					'posts_per_page'=> $post_number,
					'orderby' 		=> 'menu_order '.$orderby,
					'order'			=> $post_order,
				));
			}
				
			if($q->have_posts()):
				while($q->have_posts()): $q->the_post(); 
				$sub_title = get_post_meta(get_the_ID(), 'portfolio_service_sub_title', true);
				?>
				<div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
					<div class="project-item">
						<div class="project-thumb w-img">
							<img src="<?php echo the_post_thumbnail_url('dogri-portfolio-thumb'); ?>" alt="">
						</div>
						<div class="project-content-inner">
						<div class="project-content">
							<span><?php echo wp_trim_words( $sub_title, $content_word_count, '' ); ?></span>
							<h4><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h4>
						</div>
						<a class="round-link-40" href="<?php the_permalink(); ?>"><i class="fa-regular fa-angle-right"></i></a>
						</div>
					</div>
				</div>
				<?php 
					endwhile; 
					wp_reset_postdata(); 
				endif; 
				?>
			</div>
		</div>
	</section>
	<!-- Project area end -->

		<?php 
		endif; ?>		

	<?php
	}

}