<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Brand_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'brand_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Brand Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'brand_widget',
			[
				'label' => esc_html__( 'Brand Widget', 'dogri-elementor' ),
			]
		);	
		
		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'dogri-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'dogri-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'dogri-elementor' ),
				),
			]
		);	


		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								
								'block_image' =>
								[
									'name' => 'block_image',
									'label' => __( 'Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								  ],	

								  'block_alt_text' =>
								  [
								  'name' => 'block_alt_text',
								  'label' => esc_html__('Image Alt Text', 'dogri-elementor'),
								  'type' => Controls_Manager::TEXTAREA,
								  'default' => esc_html__('', 'dogri-elementor')
								  ],																
								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	



		//Section Padding Block==========================
        $this->start_controls_section(
            'section_padding_settings',
            array(
                'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        
        $this->add_control(
            'block_margin',
            array(
                'label'     => __( 'Block Margin', 'dogri-elementor' ),
                'type'      => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' =>  ['px', '%', 'em' ],
            
                'selectors' => array(
                    '{{WRAPPER}} .brand-area-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ),
				'responsive' => true, // This enables responsive settings
            )
        );

        $this->add_control(
            'block_padding',
            array(
                'label'     => __( 'Block Padding', 'dogri-elementor' ),
                'type'      => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' =>  ['px', '%', 'em' ],
            
                'selectors' => array(
                    '{{WRAPPER}} .brand-area-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ),
				'responsive' => true, // This enables responsive settings
            )
        );

        $this->end_controls_section();
        //End of Section Padding Block 


		    //Background Color ==========================

			$this->start_controls_section(
				'bg_color_block_settings',
				array(
					'label' => __( 'Background Color Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);			
		
			$this->add_control(
				'block_bg_color',
				array(
					'label'     => __( 'Section Background Color', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .brand-area-2' => 'background-color: {{VALUE}} !important',
					),
				)
			);
		
			$this->add_control(
				'block_bg_color_1',
				array(
					'label'     => __( 'Card Background Color', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .brand-area-2' => 'background: {{VALUE}} !important',
					),
				)
			);
		
			$this->end_controls_section();
		
			//End of Background Color  

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 

var brand = new Swiper(".brand-active", {
	slidesPerView: 5,
	spaceBetween: 30,
	loop: true,
	autoplay: {
		delay: 3000,
	},
	breakpoints: {
		"1400": {
			slidesPerView: 5,
		},
		"1200": {
			slidesPerView: 4,
		},
		"992": {
			slidesPerView: 4,
		},
		"768": {
			slidesPerView: 3,
		},
		"576": {
			slidesPerView: 2,
		},
		"0": {
			slidesPerView: 1,
		},
	},
});

//write code above the line 

  });
</script>';


?>

<?php  if ( 'style1' === $settings['style'] ) : ?>
   <!-- Brand area start -->
   <div class="brand-area section-space-bottom">
      <div class="container">
         <div class="brand-grid">
		 <?php foreach($settings['repeat'] as $item):?>
            <div class="brand-item">
               <div class="brand-thumb">
			   <img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
               </div>
            </div>
			<?php endforeach; ?>
         </div>
      </div>
   </div>
   <!-- Brand area end -->

<?php  elseif ( 'style2' === $settings['style'] ) : ?>

	<!-- Brand area start -->
	<div class="brand-area-2 theme-bg-1">
		<div class="container">
		<div class="swiper brand-active">
			<div class="swiper-wrapper">
				<?php foreach($settings['repeat'] as $item):?>
				<div class="swiper-slide">
					<div class="brand-item-2">
						<div class="brand-thumb-2">
							<img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>
		</div>
		</div>
	</div>
	<!-- Brand area end -->

<?php endif ;?>	

             
		<?php 
	}


}