<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dogri
 */
if( is_single() ): ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class('single-post-item '); ?> >
        <?php if(has_post_thumbnail()): ?>
            <div class="post-thumbnail ">
                <?php the_post_thumbnail('full', array('class' => 'img-responsive' )); ?>
            </div>
        <?php endif; ?>
        <div class="post-content-wrapper">
            <div class="post-meta ">
                <span><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><i class="far fa-user"></i> <?php print get_the_author(); ?></a></span>
                <span><i class="fa-regular fa-clock"></i><?php the_time(get_option('date_format')); ?></span>
                <span><a href="<?php comments_link(); ?>"><i class="fa-regular fa-comments"></i> <?php comments_number(); ?></a></span>
            </div>

            <?php 
            if( ! empty( $post->post_title ) ) : ?>
                <h3 class="post-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h3>
            <?php 
            endif; ?>

            <?php
            $the_content = apply_filters('the_content', get_the_content());
            if ( !empty($the_content) ): ?>
                <div class="post-content">
                <?php the_content(); ?> 
                    <?php
                        wp_link_pages( array(
                            'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'dogri' ),
                            'after'       => '</div>',
                            'link_before' => '<span class="page-number">',
                            'link_after'  => '</span>',
                        ) );
                    ?>
                </div>
            <?php
            endif; ?>

            <?php
            $show_blog_social_share     = get_theme_mod('dogri_blog_social_share');
            if( has_tag() !== false || $show_blog_social_share !== false): ?>
                <div class="single-post-meta">
                    <?php echo dogri_get_tag(); ?>
                    <?php
                    if( $show_blog_social_share ):
                    echo dogri_social_share(); 
                    endif; ?>
                </div>
            <?php
            endif; ?>
        </div>
    </article>
<?php
else: ?>

    <article id="post-<?php the_ID(); ?>" <?php post_class('single-post-item '); ?> >
        <?php if( has_post_thumbnail() ): ?>
        <div class="post-thumbnail">
            <a href="<?php the_permalink(); ?>">
                <?php the_post_thumbnail('full', array('class' => 'img-responsive' )); ?>
            </a>
        </div>
        <?php endif; ?>
        <div class="post-content-wrapper">
            <div class="post-meta ">
                <span><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><i class="far fa-user"></i> <?php print get_the_author(); ?></a></span>
                <span><i class="fa-regular fa-clock"></i><?php the_time(get_option('date_format')); ?></span>
                <span><a href="<?php comments_link(); ?>"><i class="fa-regular fa-comments"></i> <?php comments_number(); ?></a></span>
            </div>
            
            <?php 
            if( ! empty( $post->post_title ) ) : ?>
                <h3 class="post-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h3>
            <?php 
            endif; ?>

            <?php
            $the_content = apply_filters('the_content', get_the_content());
            if (!empty($the_content)) :
                ?>
                <div class="post-content">
                    <?php echo wp_trim_words($the_content, 25); ?>
                </div>
            <?php
            endif;
            ?>

            <?php 
            $dogri_blog_btn     = get_theme_mod('dogri_blog_btn', esc_html('Read More', 'dogri')); 
            $dogri_blog_btn_icon     = get_theme_mod('dogri_blog_btn_icon','fa-solid fa-angle-right'); 
            $dogri_blog_btn_switch     = get_theme_mod('dogri_blog_btn_switch'); 
            $dogri_blog_btn_icon_switch     = get_theme_mod('dogri_blog_btn_icon_switch'); 
            $show_blog_social_share     = get_theme_mod('dogri_blog_social_share'); 
            if( $dogri_blog_btn_switch ): ?>
                <div class="read-more">
                    <a href="<?php the_permalink(); ?>" class="theme-btn"><?php print esc_html($dogri_blog_btn); ?>
                        <?php 
                        if( $dogri_blog_btn_icon_switch ): ?>
                            <i class="<?php echo esc_attr( $dogri_blog_btn_icon ); ?>"></i>
                        <?php 
                        endif; ?>
                    </a>
                    
                    <?php
                    if( $show_blog_social_share ): 
                         echo dogri_social_share(); 
                    endif; ?>    
                </div>
            <?php 
            endif; ?>
        </div>
    </article>
<?php
endif; ?>