<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package dogri
 */
get_header();
$blog_column = is_active_sidebar( 'right-sidebar' ) ? 8 : 12 ;
?>
<section class="blog-area section-space">
    <div class="container">
        <div class="row">
			<div class="col-lg-<?php print esc_attr($blog_column); ?>">
				<div class="blog-details-wrapper">
					<?php
					while ( have_posts() ) :
						the_post();
						get_template_part( 'template-parts/content', get_post_format() );
						?>
					
						<?php 
						$next_post = get_next_post();
						$prev_post = get_previous_post();

						if( get_previous_post_link() AND get_next_post_link() ) : ?>

						<div class="blog-post-nav">
							<?php 
							if(get_previous_post_link()) : ?>
								<div class="post-navigation">
									<?php
									if( get_the_post_thumbnail( $prev_post ) !== "" ): ?>
										<div class="post-img">
											<?php echo get_the_post_thumbnail( $prev_post, [ 100, 100 ] ); ?>
										</div>
									<?php
									endif; ?>

									<div class="text">
										<span><i class="fa-solid fa-angle-left"></i> <?php print esc_html__( 'Previous', 'dogri' ); ?></span>
										<h4><?php print get_previous_post_link('%link ', '%title'); ?></h4>	
									</div>
								</div>
							<?php
							endif; ?>

							<div class="divider"></div>

							<?php 
							if(get_next_post_link()) : ?>
								<div class="post-navigation">
									<?php
									if( get_the_post_thumbnail( $next_post ) !== "" ): ?>
										<div class="post-img">
											<?php echo get_the_post_thumbnail( $next_post, [ 100, 100 ] ); ?>
										</div>
									<?php
									endif; ?>

									<div class="text">
										<span><?php print esc_html__( 'Next', 'dogri' ); ?></span>
										<h4><?php print get_next_post_link( '%link ', '%title' ); ?></h4>
									</div>
								</div>
							<?php
							endif; ?>	
						</div>

						<?php 
						endif; ?>

						<?php
						get_template_part( 'template-parts/biography');

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
			</div>
			<?php 
			if ( is_active_sidebar( 'right-sidebar' ) ) { ?>
		        <div class="col-lg-4 order-1 order-lg-2">
					<aside class="sidebar">
						<?php get_sidebar(); ?>
					</aside>
	            </div>
			<?php
			}
			?>
		</div>
	</div>
</section>

<?php
get_footer();