<?php
/** 
 * dogri Customizer data
 */
function dogri_customizer( $data ) {
	return array(
		'panel' => array ( 
			'id' => 'dogri',
			'name' => esc_html__('Dogri Customizer','dogri'),
			'priority' => 10,
			'section' => array(				
				'header_button_setting' => array(
					'name' => esc_html__( 'Header Button Setting', 'dogri' ),
					'priority' => 12,
					'fields' => array(
						/** header button info **/							
						array(
							'name' => esc_html__( 'Show Button', 'dogri' ),
							'id' => 'dogri_show_header_button',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Text', 'dogri' ),
							'id' => 'dogri_header_btn_text',
							'default' => esc_html__('Get A Quote','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Link', 'dogri' ),
							'id' => 'dogri_header_btn_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						// call-us
						array(
							'name' => esc_html__( 'Show Call Us', 'dogri' ),
							'id' => 'dogri_show_header_callus',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),

						array(
							'name' => esc_html__( 'Phone Icon', 'dogri' ),
							'id' => 'phone_icon',
							'default' => get_template_directory_uri() . '/img/svg/phone-call.svg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),

						array(
							'name' => esc_html__( 'Phone Number', 'dogri' ),
							'id' => 'dogri_header_callus',
							'default' => esc_html__('+380961381876','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						
						array(
							'name' => esc_html__( 'Phone Icon Two', 'dogri' ),
							'id' => 'phone_icon_1',
							'default' => get_template_directory_uri() . '/img/icons/call.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),

						array(
							'name' => esc_html__( 'Phone Number Two', 'dogri' ),
							'id' => 'dogri_header_callus_1',
							'default' => esc_html__('+380961381876','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
					) 
				),
				'header_social_setting'=> array(
					'name'=> esc_html__('Header Social Setting','dogri'),
					'priority'=> 15,
					'description' => esc_html__('To hide the field please use # in text field.', 'dogri'),
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Social Profiles', 'dogri' ),
							'id' => 'dogri_header_social_profiles',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Facebook Url', 'dogri' ),
							'id' => 'dogri_topbar_fb_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Twitter Url', 'dogri' ),
							'id' => 'dogri_topbar_twitter_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Linkedin Url', 'dogri' ),
							'id' => 'dogri_topbar_linkedin_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Youtube Url', 'dogri' ),
							'id' => 'dogri_topbar_youtube_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						)						
					)
				),
				'header_main_setting' => array(
					'name' => esc_html__( 'Header Setting', 'dogri' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Choose Header Style', 'dogri' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'header-style-1' => esc_html__( 'Header Style 1', 'dogri' ),
								'header-style-2' => esc_html__( 'Header Style 2', 'dogri' ),
								'header-style-3' => esc_html__( 'Header Style 3', 'dogri' ),
								'header-style-4' => esc_html__( 'Header Style 4', 'dogri' ),
								'header-style-5' => esc_html__( 'Header Style 5', 'dogri' ),
							),
							'default' => 'header-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Logo', 'dogri' ),
							'id' => 'logo',
							'default' => get_template_directory_uri() . '/img/logo/logo.svg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header White Logo', 'dogri' ),
							'id' => 'seconday_logo',
							'default' => get_template_directory_uri() . '/img/logo/logo-white.svg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Logo', 'dogri' ),
							'id' => 'retina_logo',
							'default' => get_template_directory_uri() . '/img/logo/logo@2x.svg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina White Logo', 'dogri' ),
							'id' => 'retina_secondary_logo',
							'default' => get_template_directory_uri() . '/img/logo/logo-white@2x.svg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Sticky Logo', 'dogri' ),
							'id' => 'sticky_logo',
							'default' => get_template_directory_uri() . '/img/logo/logo.svg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
					) 
				),	
				'header_extra_setting' => array(
					'name' => esc_html__( 'Header Extra Setting', 'dogri' ),
					'priority' => 25,
					'fields' => array(
						array(
							'name' => esc_html__( 'Logo', 'dogri' ),
							'id' => 'extra_logo',
							'default' => get_template_directory_uri() . '/img/logo/logo.svg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),					
						array(
							'name' => esc_html__( 'Contact Info Text', 'dogri' ),
							'id' => 'dogri_extra_contact_info',
							'default' => esc_html__('Contact Info','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),					
						
						array(
							'name' => esc_html__( 'Address', 'dogri' ),
							'id' => 'dogri_header_contact_address',
							'default' => esc_html__('12/A, Mirnada City Tower, NYC','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Email Address', 'dogri' ),
							'id' => 'dogri_header_contact_email',
							'default' => esc_html__('support@mail.com','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Phone Number', 'dogri' ),
							'id' => 'dogri_header_contact_phone',
							'default' => esc_html__('+088889797697','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
					) 
				),
				'preloader_setting' => array(
					'name' => esc_html__( 'Preloader Setting', 'dogri' ),
					'priority' => 28,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Preloader', 'dogri' ),
							'id' => 'dogri_show_preloader',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						// array(
						// 	'name' => esc_html__( 'Preloader Logo', 'dogri' ),
						// 	'id' => 'dogri_preloader_logo',
						// 	'default' => get_template_directory_uri() . '/img/logo/favicon.png',
						// 	'type' => 'image',
						// 	'transport'	=> 'refresh' 
						// ),
					) 
				),
				// 'rtl_setting' => array(
				// 	'name' => esc_html__( 'RTL Setting', 'dogri' ),
				// 	'priority' => 29,
				// 	'fields' => array(
				// 		array(
				// 			'name' => esc_html__( 'Enable RTL', 'dogri' ),
				// 			'id' => 'dogri_enable_rtl',
				// 			'default' => 0,
				// 			'type' => 'switch',
				// 			'transport'	=> 'refresh' 
				// 		),
				// 	) 
				// ),
				'page_title_setting'=> array(
					'name'=> esc_html__('Breadcrumb Setting','dogri'),
					'priority'=> 30,
					'fields'=> array(
						// array(
						// 	'name' => esc_html__( 'Choose Breadcrumb Style', 'dogri' ),
						// 	'id' => 'choose_default_breadcrumb',
						// 	'type'     => 'select',
						// 	'choices'  => array(
						// 		'breadcrumb-style-1' => esc_html__( 'Breadcrumb Style 1', 'dogri' ),
						// 	),
						// 	'default' => 'breadcrumb-style-1',
						// 	'transport'	=> 'refresh'
						// ),
						// array(
						// 	'name'=>esc_html__('Breadcrumb BG Color','dogri'),
						// 	'id'=>'dogri_breadcrumb_bg_color',
						// 	'default'=> esc_html__('#f4f9fc','dogri'),
						// 	'transport'	=> 'refresh'  
						// ),
						array(
							'name' => esc_html__( 'Breadcrumb Background Image', 'dogri' ),
							'id' => 'breadcrumb_bg_img',
							'default' => get_template_directory_uri() . './img/icons/breadcrumb-bg.jpg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Page Sub Title', 'dogri' ),
							'id' => 'breadcrumb_page_subtitle',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Archive', 'dogri' ),
							'id' => 'breadcrumb_archive',
							'default' => esc_html__('Archive for category','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Search', 'dogri' ),
							'id' => 'breadcrumb_search',
							'default' => esc_html__('Search results for','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb tagged', 'dogri' ),
							'id' => 'breadcrumb_post_tags',
							'default' => esc_html__('Posts tagged','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb posted by', 'dogri' ),
							'id' => 'breadcrumb_artitle_post_by',
							'default' => esc_html__('Articles posted by','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page Not Found', 'dogri' ),
							'id' => 'breadcrumb_404',
							'default' => esc_html__('Page Not Found','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page', 'dogri' ),
							'id' => 'breadcrumb_page',
							'default' => esc_html__('Page','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Shop', 'dogri' ),
							'id' => 'breadcrumb_shop',
							'default' => esc_html__('Shop','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Home', 'dogri' ),
							'id' => 'breadcrumb_home',
							'default' => esc_html__('Home','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),					
					)
				),
				'blog_setting'=> array(
					'name'=> esc_html__('Blog Setting','dogri'),
					'priority'=> 35,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Blog BTN', 'dogri' ),
							'id' => 'dogri_blog_btn_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Show Blog Btn Icon', 'dogri' ),
							'id' => 'dogri_blog_btn_icon_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Blog Button text', 'dogri' ),
							'id' => 'dogri_blog_btn',
							'default' => esc_html__('Read More','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),							
						array(
							'name' => esc_html__( 'Blog Button Icon', 'dogri' ),
							'id' => 'dogri_blog_btn_icon',
							'default' => esc_html__('fas fa-angle-double-right','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Title', 'dogri' ),
							'id' => 'breadcrumb_blog_title',
							'default' => esc_html__('Blog','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Details Title', 'dogri' ),
							'id' => 'breadcrumb_blog_title_details',
							'default' => esc_html__('Blog Details','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Show Social Share', 'dogri' ),
							'id' => 'dogri_blog_social_share',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),

					)
				),
				'dogri_footer_setting'=> array(
					'name'=> esc_html__('Footer Setting','dogri'),
					'priority'=> 50,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Choose Footer Style', 'dogri' ),
							'id' => 'choose_default_footer',
							'type'     => 'select',
							'choices'  => array(
								'footer-style-1' => esc_html__( 'Footer Style 1', 'dogri' ),
								'footer-style-2' => esc_html__( 'Footer Style 2', 'dogri' ),
								'footer-style-3' => esc_html__( 'Footer Style 3', 'dogri' ),
								'footer-style-4' => esc_html__( 'Footer Style 4', 'dogri' ),
							),
							'default' => 'footer-style-1',
							'transport'	=> 'refresh'
						),
						// array(
						// 	'name' => esc_html__( 'Footer Background Image', 'dogri' ),
						// 	'id' => 'dogri_footer_bg',
						// 	'default' => '',
						// 	'type' => 'image',
						// 	'transport'	=> 'refresh' 
						// ),
						// array(
						// 	'name'=>esc_html__('Footer BG Color','dogri'),
						// 	'id'=>'dogri_footer_bg_color',
						// 	'default'=> esc_html__('#191919','dogri'),
						// 	'transport'	=> 'refresh'  
						// ),
						// array(
						// 	'name'=>esc_html__('Footer Copyright BG Color','dogri'),
						// 	'id'=>'dogri_footer_cr_bg_color',
						// 	'default'=> esc_html__('#ffffff00','dogri'),
						// 	'transport'	=> 'refresh'  
						// ),
						array(
							'name'=>esc_html__('Copy Right','dogri'),
							'id'=>'dogri_copyright',
							'default'=> esc_html__('Copyright &copy;2023 Dogri. All Rights Reserved','dogri'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Terms Option', 'dogri' ),
							'id' => 'dogri_terms_option',
							'default' => esc_html__('Terms & Condition','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Terms Option Link', 'dogri' ),
							'id' => 'dogri_terms_option_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Privacy Policy Option', 'dogri' ),
							'id' => 'dogri_privacy_policy_option',
							'default' => esc_html__('Privacy Policy','dogri'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Privacy Policy Option Link', 'dogri' ),
							'id' => 'dogri_privacy_policy_option_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
					)
				),
				// 'portfolio_setting' => array(
				// 	'name' => esc_html__( 'Portfolios Setting', 'dogri' ),
				// 	'priority' => 65,
				// 	'fields' => array(
				// 		array(
				// 			'name' => esc_html__( 'Similar Portfolios Text', 'dogri' ),
				// 			'id' => 'dogri_portfolio_info',
				// 			'default' => esc_html__('Similar Portfolios','dogri'),
				// 			'type' => 'text',
				// 			'transport'	=> 'refresh' 
				// 		),
				// 	)
				// ),
				'error_page_setting'=> array(
					'name'=> esc_html__('404 Setting','dogri'),
					'priority'=> 70,
					'fields'=> array(
						array(
							'name'=>esc_html__('400 Text','dogri'),
							'id'=>'dogri_error_404_text',
							'default'=> esc_html__('404','dogri'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Not Found Title','dogri'),
							'id'=>'dogri_error_title',
							'default'=> esc_html__('Page not found','dogri'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Description Text','dogri'),
							'id'=>'dogri_error_desc',
							'default'=> esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted','dogri'),
							'type'=>'textarea',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Link Text','dogri'),
							'id'=>'dogri_error_link_text',
							'default'=> esc_html__('Back To Home','dogri'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						)
						
					)
				),
				// 'dogri_color_setting'=> array(
				// 	'name'=> esc_html__('Theme Color','dogri'),
				// 	'priority'=> 75,
				// 	'fields'=> array(
				// 		array(
				// 			'name'=>esc_html__('Theme Color','dogri'),
				// 			'id'=>'dogri_theme_color',
				// 			'default'=> esc_html__('#FFA801','dogri'),
				// 			'transport'	=> 'refresh'  
				// 		)						
				// 	)
				// )
			),
		)
	);

}

add_filter('dogri_customizer_data', 'dogri_customizer');