<?php
/**
 * @package Helix3 Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

// JLayout for standard handling of the edit modules:

$moduleHtml   =& $displayData['moduleHtml'];
$mod          = $displayData['module'];
$position     = $displayData['position'];
$menusEditing = $displayData['menusediting'];
$redirectUri = '&return='. urlencode(base64_encode(JUri::getInstance()->toString()));

if (preg_match('/<(?:div|span|nav|ul|ol|h\d) [^>]*class="[^"]* jmoddiv"/', $moduleHtml))
{
	// Module has already module edit button:
	return;
}

// Add css class jmoddiv and data attributes for module-editing URL and for the tooltip:
$editUrl = JUri::base() . 'index.php?option=com_config&controller=config.display.modules&id=' . (int) $mod->id . $redirectUri;

// Add class, editing URL and tooltip, and if module of type menu, also the tooltip for editing the menu item:
$count = 0;
$moduleHtml = preg_replace(
	// Replace first tag of module with a class
	'/^(\s*<(?:div|span|nav|ul|ol|h\d) [^>]*class="[^"]*)"/',
	// By itself, adding class jmoddiv and data attributes for the url and tooltip:
	'\\1 jmoddiv" data-jmodediturl="' . $editUrl . '" data-jmodtip="'
	.	JHtml::tooltipText(
			JText::_('JLIB_HTML_EDIT_MODULE'),
			htmlspecialchars($mod->title) . '<br />' . sprintf(JText::_('JLIB_HTML_EDIT_MODULE_IN_POSITION'), htmlspecialchars($position)),
			0
		)
	. '"'
	// And if menu editing is enabled and allowed and it's a menu module, add data attributes for menu editing:
	.	($menusEditing && $mod->module == 'mod_menu' ?
			'" data-jmenuedittip="' . JHtml::tooltipText('JLIB_HTML_EDIT_MENU_ITEM', 'JLIB_HTML_EDIT_MENU_ITEM_ID') . '"'
			:
			''
		),
	$moduleHtml,
	1,
	$count
);

if ($count)
{
	// Load once booststrap tooltip and add stylesheet and javascript to head:
	//JHtml::_('bootstrap.tooltip');
	//JHtml::_('bootstrap.popover');

	JHtml::_('stylesheet', 'system/frontediting.css', array(), true);
	JHtml::_('script', 'system/frontediting.js', false, true);

	//Helix3
	helix3::addLess('frontend-edit', 'frontend-edit');
    helix3::addJS('frontend-edit.js');
}
